package whichapplicationmoduleapp.model;

import oracle.jbo.ApplicationModule;
import oracle.jbo.ViewObject;
import oracle.jbo.domain.Number;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.ViewRowImpl;
// ---------------------------------------------------------------------
// ---    File generated by Oracle ADF Business Components Design Time.
// ---    Custom code may be added to this class.
// ---    Warning: Do not modify method signatures of generated methods.
// ---------------------------------------------------------------------
public class CountriesVORowImpl
	extends ViewRowImpl
{
	/**
	 * AttributesEnum: generated enum for identifying attributes and accessors. DO NOT MODIFY.
	 */
	public enum AttributesEnum
	{
		CountryId
		{
			public Object get(CountriesVORowImpl obj)
			{
				return obj.getCountryId();
			}

			public void put(CountriesVORowImpl obj, Object value)
			{
				obj.setCountryId((String)value);
			}
		}
		,
		CountryName
		{
			public Object get(CountriesVORowImpl obj)
			{
				return obj.getCountryName();
			}

			public void put(CountriesVORowImpl obj, Object value)
			{
				obj.setCountryName((String)value);
			}
		}
		,
		RegionId
		{
			public Object get(CountriesVORowImpl obj)
			{
				return obj.getRegionId();
			}

			public void put(CountriesVORowImpl obj, Object value)
			{
				obj.setRegionId((Number)value);
			}
		}
		,
		AppModInfo
		{
			public Object get(CountriesVORowImpl obj)
			{
				return obj.getAppModInfo();
			}

			public void put(CountriesVORowImpl obj, Object value)
			{
				obj.setAppModInfo((String)value);
			}
		}
		;
		private static AttributesEnum[] vals = null;
		private static final int firstIndex = 0;

		public abstract Object get(CountriesVORowImpl object);

		public abstract void put(CountriesVORowImpl object, Object value);

		public int index()
		{
			return AttributesEnum.firstIndex() + ordinal();
		}

		public static final int firstIndex()
		{
			return firstIndex;
		}

		public static int count()
		{
			return AttributesEnum.firstIndex() + AttributesEnum.staticValues().length;
		}

		public static final AttributesEnum[] staticValues()
		{
			if (vals == null)
			{
				vals = AttributesEnum.values();
			}
			return vals;
		}
	}

	public static final int COUNTRYID = AttributesEnum.CountryId.index();
	public static final int COUNTRYNAME = AttributesEnum.CountryName.index();
	public static final int REGIONID = AttributesEnum.RegionId.index();
	public static final int APPMODINFO = AttributesEnum.AppModInfo.index();

	/**
	 * This is the default constructor (do not remove).
	 */
	public CountriesVORowImpl()
	{
	}

	/**
	 * Gets Countries entity object.
	 * @return the Countries
	 */
	public EntityImpl getCountries()
	{
		return (EntityImpl)getEntity(0);
	}

	/**
	 * Gets the attribute value for COUNTRY_ID using the alias name CountryId.
	 * @return the COUNTRY_ID
	 */
	public String getCountryId()
	{
		return (String) getAttributeInternal(COUNTRYID);
	}

	/**
	 * Sets <code>value</code> as attribute value for COUNTRY_ID using the alias name CountryId.
	 * @param value value to set the COUNTRY_ID
	 */
	public void setCountryId(String value)
	{
		setAttributeInternal(COUNTRYID, value);
	}

	/**
	 * Gets the attribute value for COUNTRY_NAME using the alias name CountryName.
	 * @return the COUNTRY_NAME
	 */
	public String getCountryName()
	{
		return (String) getAttributeInternal(COUNTRYNAME);
	}

	/**
	 * Sets <code>value</code> as attribute value for COUNTRY_NAME using the alias name CountryName.
	 * @param value value to set the COUNTRY_NAME
	 */
	public void setCountryName(String value)
	{
		setAttributeInternal(COUNTRYNAME, value);
	}

	/**
	 * Gets the attribute value for REGION_ID using the alias name RegionId.
	 * @return the REGION_ID
	 */
	public Number getRegionId()
	{
		return (Number) getAttributeInternal(REGIONID);
	}

	/**
	 * Sets <code>value</code> as attribute value for REGION_ID using the alias name RegionId.
	 * @param value value to set the REGION_ID
	 */
	public void setRegionId(Number value)
	{
		setAttributeInternal(REGIONID, value);
	}

	/**
	 * Gets the attribute value for the calculated attribute AppModInfo.
	 * @return the AppModInfo
	 */
	public String getAppModInfo()
	{
//		return (String) getAttributeInternal(APPMODINFO);
		ViewObject vViewObject = getViewObject();
		ApplicationModule vApplicationModule = vViewObject.getApplicationModule();
		return "[AppModInfo : " + getClass()
			+ " : vViewObject.getApplicationModule() = " + vApplicationModule
			+ ", isRoot() = " + vApplicationModule.isRoot()
			+ "]";
	}

	/**
	 * Sets <code>value</code> as the attribute value for the calculated attribute AppModInfo.
	 * @param value value to set the  AppModInfo
	 */
	public void setAppModInfo(String value)
	{
		setAttributeInternal(APPMODINFO, value);
	}

	/**
	 * getAttrInvokeAccessor: generated method. Do not modify.
	 * @param index the index identifying the attribute
	 * @param attrDef the attribute

	 * @return the attribute value
	 * @throws Exception
	 */
	protected Object getAttrInvokeAccessor(int index,
														AttributeDefImpl attrDef)
		throws Exception
	{
		if ((index >= AttributesEnum.firstIndex()) && (index < AttributesEnum.count()))
		{
			return AttributesEnum.staticValues()[index - AttributesEnum.firstIndex()].get(this);
		}
		return super.getAttrInvokeAccessor(index, attrDef);
	}

	/**
	 * setAttrInvokeAccessor: generated method. Do not modify.
	 * @param index the index identifying the attribute
	 * @param value the value to assign to the attribute
	 * @param attrDef the attribute

	 * @throws Exception
	 */
	protected void setAttrInvokeAccessor(int index, Object value,
													 AttributeDefImpl attrDef)
		throws Exception
	{
		if ((index >= AttributesEnum.firstIndex()) && (index < AttributesEnum.count()))
		{
			AttributesEnum.staticValues()[index - AttributesEnum.firstIndex()].put(this, value);
			return;
		}
		super.setAttrInvokeAccessor(index, value, attrDef);
	}
}
