package whichapplicationmoduleapp.model;

import oracle.jbo.ApplicationModule;
import oracle.jbo.RowIterator;
import oracle.jbo.RowSet;
import oracle.jbo.ViewObject;
import oracle.jbo.domain.Number;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.ViewRowImpl;
// ---------------------------------------------------------------------
// ---    File generated by Oracle ADF Business Components Design Time.
// ---    Custom code may be added to this class.
// ---    Warning: Do not modify method signatures of generated methods.
// ---------------------------------------------------------------------
public class DepartmentsVORowImpl
	extends ViewRowImpl
{
	/**
	 * AttributesEnum: generated enum for identifying attributes and accessors. DO NOT MODIFY.
	 */
	public enum AttributesEnum
	{
		DepartmentId
		{
			public Object get(DepartmentsVORowImpl obj)
			{
				return obj.getDepartmentId();
			}

			public void put(DepartmentsVORowImpl obj, Object value)
			{
				obj.setDepartmentId((Number)value);
			}
		}
		,
		DepartmentName
		{
			public Object get(DepartmentsVORowImpl obj)
			{
				return obj.getDepartmentName();
			}

			public void put(DepartmentsVORowImpl obj, Object value)
			{
				obj.setDepartmentName((String)value);
			}
		}
		,
		LocationId
		{
			public Object get(DepartmentsVORowImpl obj)
			{
				return obj.getLocationId();
			}

			public void put(DepartmentsVORowImpl obj, Object value)
			{
				obj.setLocationId((Number)value);
			}
		}
		,
		ManagerId
		{
			public Object get(DepartmentsVORowImpl obj)
			{
				return obj.getManagerId();
			}

			public void put(DepartmentsVORowImpl obj, Object value)
			{
				obj.setManagerId((Number)value);
			}
		}
		,
		AppModInfo
		{
			public Object get(DepartmentsVORowImpl obj)
			{
				return obj.getAppModInfo();
			}

			public void put(DepartmentsVORowImpl obj, Object value)
			{
				obj.setAppModInfo((String)value);
			}
		}
		,
		EmpAppModInfo
		{
			public Object get(DepartmentsVORowImpl obj)
			{
				return obj.getEmpAppModInfo();
			}

			public void put(DepartmentsVORowImpl obj, Object value)
			{
				obj.setEmpAppModInfo((String)value);
			}
		}
		,
		EmployeesVO
		{
			public Object get(DepartmentsVORowImpl obj)
			{
				return obj.getEmployeesVO();
			}

			public void put(DepartmentsVORowImpl obj, Object value)
			{
				obj.setAttributeInternal(index(), value);
			}
		}
		;
		private static AttributesEnum[] vals = null;
		private static final int firstIndex = 0;

		public abstract Object get(DepartmentsVORowImpl object);

		public abstract void put(DepartmentsVORowImpl object, Object value);

		public int index()
		{
			return AttributesEnum.firstIndex() + ordinal();
		}

		public static final int firstIndex()
		{
			return firstIndex;
		}

		public static int count()
		{
			return AttributesEnum.firstIndex() + AttributesEnum.staticValues().length;
		}

		public static final AttributesEnum[] staticValues()
		{
			if (vals == null)
			{
				vals = AttributesEnum.values();
			}
			return vals;
		}
	}

	public static final int DEPARTMENTID = AttributesEnum.DepartmentId.index();
	public static final int DEPARTMENTNAME = AttributesEnum.DepartmentName.index();
	public static final int LOCATIONID = AttributesEnum.LocationId.index();
	public static final int MANAGERID = AttributesEnum.ManagerId.index();
	public static final int APPMODINFO = AttributesEnum.AppModInfo.index();
	public static final int EMPAPPMODINFO = AttributesEnum.EmpAppModInfo.index();
	public static final int EMPLOYEESVO = AttributesEnum.EmployeesVO.index();

	/**
	 * This is the default constructor (do not remove).
	 */
	public DepartmentsVORowImpl()
	{
	}

	/**
	 * Gets Departments entity object.
	 * @return the Departments
	 */
	public EntityImpl getDepartments()
	{
		return (EntityImpl)getEntity(0);
	}

	/**
	 * Gets the attribute value for DEPARTMENT_ID using the alias name DepartmentId.
	 * @return the DEPARTMENT_ID
	 */
	public Number getDepartmentId()
	{
		return (Number) getAttributeInternal(DEPARTMENTID);
	}

	/**
	 * Sets <code>value</code> as attribute value for DEPARTMENT_ID using the alias name DepartmentId.
	 * @param value value to set the DEPARTMENT_ID
	 */
	public void setDepartmentId(Number value)
	{
		setAttributeInternal(DEPARTMENTID, value);
	}

	/**
	 * Gets the attribute value for DEPARTMENT_NAME using the alias name DepartmentName.
	 * @return the DEPARTMENT_NAME
	 */
	public String getDepartmentName()
	{
		return (String) getAttributeInternal(DEPARTMENTNAME);
	}

	/**
	 * Sets <code>value</code> as attribute value for DEPARTMENT_NAME using the alias name DepartmentName.
	 * @param value value to set the DEPARTMENT_NAME
	 */
	public void setDepartmentName(String value)
	{
		setAttributeInternal(DEPARTMENTNAME, value);
	}

	/**
	 * Gets the attribute value for LOCATION_ID using the alias name LocationId.
	 * @return the LOCATION_ID
	 */
	public Number getLocationId()
	{
		return (Number) getAttributeInternal(LOCATIONID);
	}

	/**
	 * Sets <code>value</code> as attribute value for LOCATION_ID using the alias name LocationId.
	 * @param value value to set the LOCATION_ID
	 */
	public void setLocationId(Number value)
	{
		setAttributeInternal(LOCATIONID, value);
	}

	/**
	 * Gets the attribute value for MANAGER_ID using the alias name ManagerId.
	 * @return the MANAGER_ID
	 */
	public Number getManagerId()
	{
		return (Number) getAttributeInternal(MANAGERID);
	}

	/**
	 * Sets <code>value</code> as attribute value for MANAGER_ID using the alias name ManagerId.
	 * @param value value to set the MANAGER_ID
	 */
	public void setManagerId(Number value)
	{
		setAttributeInternal(MANAGERID, value);
	}

	/**
	 * Gets the attribute value for the calculated attribute AppModInfo.
	 * @return the AppModInfo
	 */
	public String getAppModInfo()
	{
//		return (String) getAttributeInternal(APPMODINFO);
		ViewObject vViewObject = getViewObject();
		ApplicationModule vApplicationModule = vViewObject.getApplicationModule();
		return "[AppModInfo : " + getClass()
			+ " : vViewObject.getApplicationModule() = " + vApplicationModule
			+ ", isRoot() = " + vApplicationModule.isRoot()
			+ "]";
	}

	/**
	 * Sets <code>value</code> as the attribute value for the calculated attribute AppModInfo.
	 * @param value value to set the  AppModInfo
	 */
	public void setAppModInfo(String value)
	{
		setAttributeInternal(APPMODINFO, value);
	}

	/**
	 * Gets the attribute value for the calculated attribute EmpAppModInfo.
	 * @return the EmpAppModInfo
	 */
	public String getEmpAppModInfo()
	{
//		return (String) getAttributeInternal(EMPAPPMODINFO);
		RowIterator vEmployeesVORowIterator = getEmployeesVO();
		RowSet vEmployeesVORowSet = (RowSet)vEmployeesVORowIterator;
		ApplicationModule vApplicationModule = vEmployeesVORowSet.getApplicationModule();
		return "[EmpAppModInfo"
			+ " : vEmployeesVORowSet.getApplicationModule() = " + vApplicationModule
			+ ", isRoot() = " + vApplicationModule.isRoot()
			+ "]";
	}

	/**
	 * Sets <code>value</code> as the attribute value for the calculated attribute EmpAppModInfo.
	 * @param value value to set the  EmpAppModInfo
	 */
	public void setEmpAppModInfo(String value)
	{
		setAttributeInternal(EMPAPPMODINFO, value);
	}

	/**
	 * Gets the associated <code>RowIterator</code> using master-detail link EmployeesVO.
	 */
	public RowIterator getEmployeesVO()
	{
		return (RowIterator)getAttributeInternal(EMPLOYEESVO);
	}

	/**
	 * getAttrInvokeAccessor: generated method. Do not modify.
	 * @param index the index identifying the attribute
	 * @param attrDef the attribute

	 * @return the attribute value
	 * @throws Exception
	 */
	protected Object getAttrInvokeAccessor(int index,
														AttributeDefImpl attrDef)
		throws Exception
	{
		if ((index >= AttributesEnum.firstIndex()) && (index < AttributesEnum.count()))
		{
			return AttributesEnum.staticValues()[index - AttributesEnum.firstIndex()].get(this);
		}
		return super.getAttrInvokeAccessor(index, attrDef);
	}

	/**
	 * setAttrInvokeAccessor: generated method. Do not modify.
	 * @param index the index identifying the attribute
	 * @param value the value to assign to the attribute
	 * @param attrDef the attribute

	 * @throws Exception
	 */
	protected void setAttrInvokeAccessor(int index, Object value,
													 AttributeDefImpl attrDef)
		throws Exception
	{
		if ((index >= AttributesEnum.firstIndex()) && (index < AttributesEnum.count()))
		{
			AttributesEnum.staticValues()[index - AttributesEnum.firstIndex()].put(this, value);
			return;
		}
		super.setAttrInvokeAccessor(index, value, attrDef);
	}
}
